/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.conndata;

import com.ibm.hwmca.base.rsf.conndata.DunDialInfo;
import com.ibm.hwmca.base.rsf.conndata.Region;
import com.ibm.hwmca.base.rsf.conndata.RetainConnectionDataManager;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Arrays;

public class IspDialInfo {
    private static final String TRACE_MASKT = "XCDIIDIT";
    private static final String TRACE_MASKF = "XCDIIDIF";
    private static final String TRACE_MASKD = "XCDIIDID";
    static final int ISO_COUNTRY_START = 0;
    static final int ISO_COUNTRY_END = 2;
    static final int ISO_REGION_START = 3;
    static final int ISO_REGION_END = 5;
    static final int LOCATION_START = 6;
    static final int LOCATION_END = 26;
    static final int NUMBER_START = 27;
    static final int NUMBER_END = 59;
    static final int COUNTRY_START = 30;
    static final int COUNTRY_END = 72;
    static final int NAME_START = 10;
    static final int NAME_END = 30;

    private IspDialInfo() {
        Trace.trace(TRACE_MASKT, "<> IspDialInfo()");
    }

    public static DunDialInfo[] getDialInfo(String countryAbbreviation, String regionAbbreviation) throws IllegalArgumentException, HException {
        Trace.trace(TRACE_MASKT, "-> IspDialInfo.getDialInfo() - " + countryAbbreviation + "," + regionAbbreviation);
        if (countryAbbreviation == null) {
            String msg = "Country parameter can not be null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        if (regionAbbreviation == null) {
            String msg = "Region parameter can not be null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String cCodeIn = countryAbbreviation.trim().toUpperCase();
        if (cCodeIn.length() != 2) {
            String msg = "Parameter >" + countryAbbreviation + "< is not a valid country abbreviation";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String rCodeIn = null;
        rCodeIn = regionAbbreviation.equals("  ") ? regionAbbreviation : regionAbbreviation.trim().toUpperCase();
        if (!rCodeIn.equals("  ") && rCodeIn.length() != 2) {
            String msg = "Parameter >" + regionAbbreviation + "< is not a valid region abbreviation";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String[] lines = RetainConnectionDataManager.getPhoneData();
        ArrayList<DunDialInfo> data = new ArrayList<DunDialInfo>();
        String localeIn = cCodeIn + "," + rCodeIn;
        boolean found = false;
        int i = 0;
        while (i < lines.length) {
            String cCode = lines[i].substring(0, 2);
            String rCode = lines[i].substring(3, 5);
            if (localeIn.equals(cCode + "," + rCode)) {
                String location = lines[i].substring(6, 26).trim();
                String number = lines[i].substring(27, 59).trim();
                data.add(new DunDialInfo(number, number, cCode, rCode, location, ""));
                found = true;
            }
            ++i;
        }
        if (!found) {
            String msg = "Country and region >" + localeIn + "< not found in database";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        Object[] numbers = data.toArray(new DunDialInfo[0]);
        Arrays.sort(numbers);
        Trace.trace(TRACE_MASKT, "<- IspDialInfo.getDialInfo()");
        return numbers;
    }

    public static DunDialInfo[] getMultiRegionDialInfo(String countryAbbreviation) throws IllegalArgumentException, HException {
        Trace.trace(TRACE_MASKT, "-> IspDialInfo.getMultiRegionDialInfo() - " + countryAbbreviation);
        if (countryAbbreviation == null) {
            String msg = "Country parameter can not be null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String cCodeIn = countryAbbreviation.trim().toUpperCase();
        if (cCodeIn.length() != 2) {
            String msg = "Parameter >" + countryAbbreviation + "< is not a valid country abbreviation";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String[] lines = RetainConnectionDataManager.getPhoneData();
        ArrayList<DunDialInfo> data = new ArrayList<DunDialInfo>();
        boolean found = false;
        boolean hasRegions = false;
        int i = 0;
        while (i < lines.length) {
            String cCode = lines[i].substring(0, 2);
            if (cCodeIn.equals(cCode)) {
                String rCode = lines[i].substring(3, 5);
                String location = lines[i].substring(6, 26).trim();
                String number = lines[i].substring(27, 59).trim();
                if (rCode.equals("  ")) {
                    data.add(new DunDialInfo(number, number, cCode, rCode, location, ""));
                } else {
                    hasRegions = true;
                }
                found = true;
            }
            ++i;
        }
        if (!found) {
            String msg = "Country>" + cCodeIn + "< not found in database";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        Object[] numbers = new DunDialInfo[]{};
        if (hasRegions) {
            numbers = data.toArray(new DunDialInfo[0]);
        }
        Arrays.sort(numbers);
        Trace.trace(TRACE_MASKT, "<- IspDialInfo.getMultiRegionDialInfo()");
        return numbers;
    }

    public static Region[] getCountryList() throws HException {
        Trace.trace(TRACE_MASKT, "-> IspDialInfo.getCountryList()");
        String[] lines = RetainConnectionDataManager.getPhoneData();
        ArrayList<String> isoCodes = new ArrayList<String>();
        String isoCode = "";
        String isoCodePrevious = "";
        int i = 0;
        while (i < lines.length) {
            isoCode = lines[i].substring(0, 2);
            if (!isoCodePrevious.equals(isoCode) && !isoCodes.contains(isoCode)) {
                isoCodes.add(isoCode);
            }
            isoCodePrevious = isoCode;
            ++i;
        }
        lines = RetainConnectionDataManager.getAccountData();
        Object[] countries = new Region[isoCodes.size()];
        int i2 = 0;
        while (i2 < lines.length) {
            isoCode = lines[i2].substring(0, 2);
            int index = isoCodes.indexOf(isoCode);
            String country = lines[i2].substring(30, 72).trim();
            if (country.substring(0, 2).equals("U ")) {
                country = country.substring(2);
            }
            if (index != -1) {
                countries[index] = new Region(country, isoCode);
            }
            ++i2;
        }
        Arrays.sort(countries);
        Trace.trace(TRACE_MASKT, "<- IspDialInfo.getCountryList()");
        return countries;
    }

    public static Region[] getRegionList(String countryAbbreviation) throws IllegalArgumentException, HException {
        Trace.trace(TRACE_MASKT, "-> IspDialInfo.getRegionList() - " + countryAbbreviation);
        if (countryAbbreviation == null) {
            String msg = "Country parameter can not be null";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        String isoCode = countryAbbreviation.trim().toUpperCase();
        if (isoCode.length() != 2) {
            String msg = "Parameter >" + countryAbbreviation + "< is not a valid country abbreviation";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        boolean found = false;
        String[] lines = RetainConnectionDataManager.getTcpData();
        ArrayList<Region> data = new ArrayList<Region>();
        int i = 0;
        while (i < lines.length) {
            String cCode = lines[i].substring(0, 2);
            String rCode = lines[i].substring(3, 5);
            String temp = "";
            if (cCode.equals(isoCode)) {
                if (!rCode.equals("  ")) {
                    temp = lines[i].substring(10, 30);
                    data.add(new Region(temp, rCode));
                }
                found = true;
            }
            ++i;
        }
        if (!found) {
            String msg = "Parameter >" + countryAbbreviation + "< is not a valid country";
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        Object[] regions = data.toArray(new Region[0]);
        Arrays.sort(regions);
        Trace.trace(TRACE_MASKT, "<- IspDialInfo.getRegionList()");
        return regions;
    }

    static void dumpCache() {
        Trace.trace(TRACE_MASKT, "-> IspDialInfo.dumpCache()");
        Trace.trace(TRACE_MASKT, "<- IspDialInfo.dumpCache()");
    }

    public static String[] getAllPhoneNumbers() throws HException {
        Trace.trace(TRACE_MASKT, "-> IspDialInfo.getAllPhoneNumbers()");
        String[] lines = RetainConnectionDataManager.getPhoneData();
        String[] numbers = new String[lines.length];
        ArrayList data = new ArrayList();
        int i = 0;
        while (i < lines.length) {
            numbers[i] = lines[i].substring(27, 59).trim();
            ++i;
        }
        Trace.trace(TRACE_MASKT, "<- IspDialInfo.getAllPhoneNumbers()");
        return numbers;
    }
}

